<?php

include_once 'conexao.php';
  
class ModeloCandidatoAulaEstudada
{     
	static public function mdlAddCandidatoAulaEstudadaPrimeiraParte($dados){ 
  
		$stmt = Conexao::conectar()->prepare("INSERT INTO candidatoaulaestudada 
						(idCandidato, inicio,idTema) VALUES (:idCandidato, :inicio,:idTema)");
		$stmt->bindParam(":idTema", $dados["idTema"], PDO::PARAM_STR);
		$stmt->bindParam(":inicio", $dados["inicio"], PDO::PARAM_STR);
		$stmt->bindParam(":idCandidato", $dados["idUsuario"], PDO::PARAM_STR);
 
		if($stmt->execute()){
			return "ok";
		}else{
			return "error";
		}

	}
 
	static public function mdlMostrarCandidatoAulaEstudadaPorIdCandidatoEidTema($idTema,$idCandidato) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM candidatoaulaestudada where idTema = :idTema and idCandidato = :idCandidato");
			$stmt->bindParam(":idTema", $idTema, PDO::PARAM_STR);
			$stmt->bindParam(":idCandidato", $idCandidato, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarTodosConcorrentesDaVagaEidVaga($idVaga) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM candidatovaga where idVaga = :idVaga");
			$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}
 
	static public function mdlMostrarTodosVagasDoConcorrentesPoridCandidato($idCandidato) { 

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM candidatovaga where idCandidato = :idCandidato");
			$stmt->bindParam(":idCandidato", $idCandidato, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}
	 

	static public function mdlMostrarTodosCandidatos() {

		$resultado = array();

			$stmt = Conexao::conectar()->prepare("SELECT * FROM candidatovaga ");
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlActualizarCandidatoAulaEstudadaAteFinal($idTema, $idCandidato, $termino) {

			$stmt = Conexao::conectar()->prepare("UPDATE candidatoaulaestudada SET termino = :termino where idTema = :idTema AND idCandidato = :idCandidato "); 
			$stmt->bindParam(":termino", $termino, PDO::PARAM_STR);
			$stmt->bindParam(":idTema", $idTema, PDO::PARAM_STR);
			$stmt->bindParam(":idCandidato", $idCandidato, PDO::PARAM_STR);
			$stmt ->execute();

	}

	static public function mdlActualizarValorPagoPeloCertificadoEDoEstadoDoPagamentoDoCertificadoCandidatoVagaPoridVagaEidCandidato($idVaga, $idCandidato, $valorPagoCertificado,$estadoDoPagamentoCertificado) {

		$stmt = Conexao::conectar()->prepare("UPDATE candidatovaga SET valorPagoCertificado = :valorPagoCertificado, estadoDoPagamentoCertificado = :estadoDoPagamentoCertificado where idVaga = :idVaga AND idCandidato = :idCandidato ");
		$stmt->bindParam(":idCandidato", $idCandidato, PDO::PARAM_STR);
		$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
		$stmt->bindParam(":estadoDoPagamentoCertificado", $estadoDoPagamentoCertificado, PDO::PARAM_STR); 
		$stmt->bindParam(":valorPagoCertificado", $valorPagoCertificado, PDO::PARAM_STR);
		$stmt ->execute();

}

	

	static public function mdlEliminarLikeDoEventoPorIdLike($id, $idUsuario){
 
		$stmt = Conexao::conectar()->prepare("DELETE FROM eventolikes where idEvento = :id and idUsuario = :idUsuario");
		$stmt->bindParam(":id", $id, PDO::PARAM_STR);
		$stmt->bindParam(":idUsuario", $idUsuario, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}

	}

}



?>